
<?php $__env->startSection('title', $title); ?>
<?php $__env->startSection('content'); ?>
<div class="mt-4 mb-8">
    <div class="flex items-center justify-between">
        <h2 class="text-xl font-semibold dark:text-white text-dark">Notifications</h2>
        
        <div class="flex space-x-2">
            <?php if($notifications->where('is_read', false)->count() > 0): ?>
            <a href="<?php echo e(route('notifications.markAll')); ?>" class="inline-flex items-center text-xs font-medium px-3 py-1.5 rounded-md dark:bg-dark-100 bg-light-200/60 dark:text-gray-300 text-gray-700 dark:hover:bg-dark-100/80 hover:bg-light-200">
                <i class="fas fa-check-circle h-3.5 w-3.5 mr-1"></i>
                <span>Mark all as read</span>
            </a>
            <?php endif; ?>
            
            <?php if($notifications->count() > 0): ?>
            <a href="<?php echo e(route('notifications.deleteAll')); ?>" onclick="return confirm('Are you sure you want to delete all notifications?')" class="inline-flex items-center text-xs font-medium px-3 py-1.5 rounded-md dark:bg-dark-100 bg-light-200/60 dark:text-gray-300 text-gray-700 dark:hover:bg-dark-100/80 hover:bg-light-200">
                <i class="fas fa-trash-alt h-3.5 w-3.5 mr-1"></i>
                <span>Clear all</span>
            </a>
            <?php endif; ?>
        </div>
    </div>
    
    <div class="mt-6">
        <?php if($notifications->count() > 0): ?>
            <div class="dark:bg-dark-50 bg-light-100 dark:border-dark-100 border-light-200 border rounded-lg overflow-hidden">
                <?php $__currentLoopData = $notifications; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $notification): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="p-4 dark:border-dark-100/60 border-light-200/60 border-b last:border-b-0 <?php echo e($notification->is_read ? '' : 'dark:bg-dark-100/50 bg-light-200/50'); ?>">
                    <div class="flex items-start gap-4">
                        <div class="<?php echo e($notification->icon_bg_color ?? 'bg-primary/10'); ?> h-10 w-10 rounded-full flex items-center justify-center flex-shrink-0">
                            <i class="fas <?php echo e($notification->icon ?? 'fa-bell'); ?> h-5 w-5 text-primary"></i>
                        </div>
                        
                        <div class="flex-1 min-w-0">
                            <div class="flex items-start justify-between flex-wrap gap-2">
                                <h3 class="text-sm font-semibold dark:text-white text-dark"><?php echo e($notification->title ?? 'Notification'); ?></h3>
                                <time datetime="<?php echo e($notification->created_at); ?>" class="text-xs dark:text-gray-400 text-gray-500"><?php echo e($notification->created_at->diffForHumans()); ?></time>
                            </div>
                            
                            <p class="mt-1 text-sm dark:text-gray-300 text-gray-700"><?php echo e($notification->message); ?></p>
                            
                            <div class="mt-3 flex items-center gap-3">
                                <?php if(!$notification->is_read): ?>
                                <a href="<?php echo e(route('notifications.mark', $notification->id)); ?>" class="inline-flex items-center text-xs font-medium px-2 py-1 rounded dark:bg-primary/20 bg-primary/10 dark:text-primary-light text-primary dark:hover:bg-primary/30 hover:bg-primary/20">
                                    <i class="fas fa-check h-3 w-3 mr-1"></i>
                                    <span>Mark as read</span>
                                </a>
                                <?php endif; ?>
                                
                                <?php if($notification->link): ?>
                                <a href="<?php echo e(route('notifications.mark', $notification->id)); ?>" class="inline-flex items-center text-xs font-medium px-2 py-1 rounded dark:bg-dark-100 bg-light-200/60 dark:text-gray-300 text-gray-700 dark:hover:bg-dark-100/80 hover:bg-light-200">
                                    <i class="fas fa-external-link-alt h-3 w-3 mr-1"></i>
                                    <span>View details</span>
                                </a>
                                <?php endif; ?>
                                
                                <a href="<?php echo e(route('notifications.delete', $notification->id)); ?>" onclick="return confirm('Are you sure you want to delete this notification?')" class="inline-flex items-center text-xs font-medium px-2 py-1 rounded dark:bg-danger/20 bg-danger/10 dark:text-danger-light text-danger dark:hover:bg-danger/30 hover:bg-danger/20">
                                    <i class="fas fa-trash-alt h-3 w-3 mr-1"></i>
                                    <span>Delete</span>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
            
            <div class="mt-4">
                <?php echo e($notifications->links()); ?>

            </div>
        <?php else: ?>
            <div class="dark:bg-dark-50 bg-light-100 dark:border-dark-100 border-light-200 border rounded-lg p-6 text-center">
                <div class="h-16 w-16 rounded-full bg-light-200/60 dark:bg-dark-100/60 flex items-center justify-center mx-auto mb-4">
                    <i class="fas fa-bell-slash h-8 w-8 dark:text-gray-400 text-gray-600"></i>
                </div>
                <h3 class="text-base font-medium dark:text-white text-dark mb-1">No notifications</h3>
                <p class="text-sm dark:text-gray-400 text-gray-600">You don't have any notifications yet.</p>
            </div>
        <?php endif; ?>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.dash', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/firstcomercial/public_html/demo.firstcomercial.legal/resources/views/user/notifications/index.blade.php ENDPATH**/ ?>