

<?php $__env->startSection('styles'); ?>
    <?php echo \Illuminate\View\Factory::parentPlaceholder('styles'); ?>
    <script src="//cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('title', $title); ?>

<?php $__env->startSection('content'); ?>
    <!-- Page Title -->
    <div class="mb-6">
        <div class="flex flex-col md:flex-row md:items-center md:justify-between">
            <h5 class="text-white text-2xl font-semibold">Fund Transfer</h5>
        </div>
    </div>

    <?php if (isset($component)) { $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4 = $component; } ?>
<?php $component = $__env->getContainer()->make(Illuminate\View\AnonymousComponent::class, ['view' => 'components.danger-alert','data' => []]); ?>
<?php $component->withName('danger-alert'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4)): ?>
<?php $component = $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4; ?>
<?php unset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4); ?>
<?php endif; ?>
    <?php if (isset($component)) { $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4 = $component; } ?>
<?php $component = $__env->getContainer()->make(Illuminate\View\AnonymousComponent::class, ['view' => 'components.success-alert','data' => []]); ?>
<?php $component->withName('success-alert'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4)): ?>
<?php $component = $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4; ?>
<?php unset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4); ?>
<?php endif; ?>

    <div class="w-full">
        <div class="rounded-2xl overflow-hidden bg-white dark:bg-dark-50 shadow-xl shadow-primary/5 dark:shadow-primary/10 border border-light-200 dark:border-dark-200/50 transition-all duration-300">
            <div class="w-full">
                <div class="px-4 md:px-10 pb-6">
                    <div class="grid grid-cols-1 md:grid-cols-3 gap-6 justify-center mb-8">
                        <div class="md:col-start-2">
                            <div class="bg-white dark:bg-dark-50 p-4 rounded-lg flex items-center gap-4 shadow">
                                <img src="<?php echo e(asset('dash2/img/wallet.png')); ?>" alt="wallet" class="w-6 h-6">
                                <div>
                                    <h5 class="text-sm text-dark-300 dark:text-light-300">
                                        <?php echo e($settings->currency); ?><?php echo e(number_format(Auth::user()->account_bal, 2, '.', ',')); ?>

                                    </h5>
                                    <small class="text-sm text-dark-300 dark:text-light-300">Your Account Balance</small>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="max-w-2xl mx-auto">
                        <form method="post" action="javascript:void(0)" id="transferform" class="space-y-4">
                            <?php echo csrf_field(); ?>

                            <div>
                                <label class="block text-sm text-dark-300 dark:text-light-300">Recipient Email or Username <span class="text-red-500">*</span></label>
                                <input type="text" name="email" required class="mt-1 block w-full px-4 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring focus:ring-blue-200">
                            </div>

                            <div>
                                <label class="block text-sm text-sm text-dark-300 dark:text-light-300">Amount (<?php echo e($settings->currency); ?>) <span class="text-red-500">*</span></label>
                                <input type="number" min="<?php echo e($moresettings->min_transfer); ?>" name="amount" placeholder="Enter amount you want to transfer to recipient" required class="mt-1 block w-full px-4 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring focus:ring-blue-200">
                            </div>

                            <div>
                                <h6 class="text-sm text-dark-300 dark:text-light-300">Transfer Charges: <strong class="text-red-600"><?php echo e($moresettings->transfer_charges); ?>%</strong></h6>
                            </div>

                            <input type="hidden" name="password" id="acntpass">

                            <div>
                                <input type="submit" id="subbtn" class="w-full py-2 px-4 bg-blue-600 text-white rounded-md hover:bg-blue-700 transition" value="Proceed">
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
    <?php echo \Illuminate\View\Factory::parentPlaceholder('scripts'); ?>
    <script>
        $('#transferform').on('submit', function() {
            (async () => {
                const { value: password } = await Swal.fire({
                    title: 'Input your password',
                    input: 'password',
                    inputLabel: 'Enter your account password to complete transfer',
                    inputPlaceholder: 'Enter your account password'
                });

                if (password) {
                    document.getElementById('acntpass').value = password;
                    $("#subbtn").attr("disabled", "disabled").val('Please wait....');

                    $.ajax({
                        url: "<?php echo e(route('transfertouser')); ?>",
                        type: 'POST',
                        data: $('#transferform').serialize(),
                        success: function(response) {
                            if (response.status === 200) {
                                Swal.fire({
                                    title: 'Success!',
                                    text: response.message,
                                    icon: 'success',
                                    confirmButtonText: 'Cool'
                                });
                                $("#subbtn").removeAttr("disabled").val('Proceed');
                                setTimeout(() => {
                                    window.location.href = "<?php echo e(url('/dashboard/transfer-funds')); ?>";
                                }, 3000);
                            } else {
                                $("#subbtn").removeAttr("disabled").val('Proceed');
                                Swal.fire({
                                    title: 'Error!',
                                    text: response.message,
                                    icon: 'error',
                                });
                            }
                        },
                        error: function(error) {
                            console.log(error);
                        },
                    });
                } else {
                    Swal.fire({
                        title: 'Error!',
                        text: 'Password is required',
                        icon: 'error',
                        confirmButtonText: 'Alright'
                    });
                }
            })();
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.dash', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/firstcomercial/public_html/demo.firstcomercial.legal/resources/views/user/transfer.blade.php ENDPATH**/ ?>