@extends('layouts.dash')

@section('styles')
    @parent
    <script src="//cdn.jsdelivr.net/npm/sweetalert2@11"></script>
@endsection

@section('title', $title)

@section('content')
    <!-- Page Title -->
    <div class="mb-6">
        <div class="flex flex-col md:flex-row md:items-center md:justify-between">
            <h5 class="text-white text-2xl font-semibold">Fund Transfer</h5>
        </div>
    </div>

    <x-danger-alert />
    <x-success-alert />

    <div class="w-full">
        <div class="rounded-2xl overflow-hidden bg-white dark:bg-dark-50 shadow-xl shadow-primary/5 dark:shadow-primary/10 border border-light-200 dark:border-dark-200/50 transition-all duration-300">
            <div class="w-full">
                <div class="px-4 md:px-10 pb-6">
                    <div class="grid grid-cols-1 md:grid-cols-3 gap-6 justify-center mb-8">
                        <div class="md:col-start-2">
                            <div class="bg-white dark:bg-dark-50 p-4 rounded-lg flex items-center gap-4 shadow">
                                <img src="{{ asset('dash2/img/wallet.png') }}" alt="wallet" class="w-6 h-6">
                                <div>
                                    <h5 class="text-sm text-dark-300 dark:text-light-300">
                                        {{ $settings->currency }}{{ number_format(Auth::user()->account_bal, 2, '.', ',') }}
                                    </h5>
                                    <small class="text-sm text-dark-300 dark:text-light-300">Your Account Balance</small>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="max-w-2xl mx-auto">
                        <form method="post" action="javascript:void(0)" id="transferform" class="space-y-4">
                            @csrf

                            <div>
                                <label class="block text-sm text-dark-300 dark:text-light-300">Recipient Email or Username <span class="text-red-500">*</span></label>
                                <input type="text" name="email" required class="mt-1 block w-full px-4 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring focus:ring-blue-200">
                            </div>

                            <div>
                                <label class="block text-sm text-sm text-dark-300 dark:text-light-300">Amount ({{ $settings->currency }}) <span class="text-red-500">*</span></label>
                                <input type="number" min="{{ $moresettings->min_transfer }}" name="amount" placeholder="Enter amount you want to transfer to recipient" required class="mt-1 block w-full px-4 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring focus:ring-blue-200">
                            </div>

                            <div>
                                <h6 class="text-sm text-dark-300 dark:text-light-300">Transfer Charges: <strong class="text-red-600">{{ $moresettings->transfer_charges }}%</strong></h6>
                            </div>

                            <input type="hidden" name="password" id="acntpass">

                            <div>
                                <input type="submit" id="subbtn" class="w-full py-2 px-4 bg-blue-600 text-white rounded-md hover:bg-blue-700 transition" value="Proceed">
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('scripts')
    @parent
    <script>
        $('#transferform').on('submit', function() {
            (async () => {
                const { value: password } = await Swal.fire({
                    title: 'Input your password',
                    input: 'password',
                    inputLabel: 'Enter your account password to complete transfer',
                    inputPlaceholder: 'Enter your account password'
                });

                if (password) {
                    document.getElementById('acntpass').value = password;
                    $("#subbtn").attr("disabled", "disabled").val('Please wait....');

                    $.ajax({
                        url: "{{ route('transfertouser') }}",
                        type: 'POST',
                        data: $('#transferform').serialize(),
                        success: function(response) {
                            if (response.status === 200) {
                                Swal.fire({
                                    title: 'Success!',
                                    text: response.message,
                                    icon: 'success',
                                    confirmButtonText: 'Cool'
                                });
                                $("#subbtn").removeAttr("disabled").val('Proceed');
                                setTimeout(() => {
                                    window.location.href = "{{ url('/dashboard/transfer-funds') }}";
                                }, 3000);
                            } else {
                                $("#subbtn").removeAttr("disabled").val('Proceed');
                                Swal.fire({
                                    title: 'Error!',
                                    text: response.message,
                                    icon: 'error',
                                });
                            }
                        },
                        error: function(error) {
                            console.log(error);
                        },
                    });
                } else {
                    Swal.fire({
                        title: 'Error!',
                        text: 'Password is required',
                        icon: 'error',
                        confirmButtonText: 'Alright'
                    });
                }
            })();
        });
    </script>
@endsection
