"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "default", {
    enumerable: true,
    get: function() {
        return ProvisioningProfileApi;
    }
});
const _provisioningProfile = /*#__PURE__*/ _interop_require_default(require("./provisioningProfile"));
const _provisioningProfileApi = require("./provisioningProfileApi");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
let ProvisioningProfileApi = class ProvisioningProfileApi {
    /**
   * Retrieves provisioning profiles, provides pagination in infinite scroll style
   * @param {ProvisioningProfilesFilter} [filter] provisioning profiles filter
   * @return {Promise<Array<ProvisioningProfile>>} promise resolving with an 
   * array of provisioning profile entities
   */ async getProvisioningProfilesWithInfiniteScrollPagination(filter) {
        let profiles = await this._provisioningProfileClient.getProvisioningProfiles(filter, "1");
        return profiles.map((p)=>new _provisioningProfile.default(p, this._provisioningProfileClient));
    }
    /**
   * Retrieves provisioning profiles and count, provides pagination in a classic style
   * @param {ProvisioningProfilesFilter} [filter] provisioning profiles filter
   * @return {Promise<ProvisioningProfilesList>} promise resolving with provisioning profile entities and count
   */ async getProvisioningProfilesWithClassicPagination(filter) {
        let profiles = await this._provisioningProfileClient.getProvisioningProfiles(filter, "2");
        return {
            count: profiles.count,
            items: profiles.items.map((p)=>new _provisioningProfile.default(p, this._provisioningProfileClient))
        };
    }
    /**
   * Retrieves a provisioning profile by id
   * @param {String} provisioningProfileId provisioning profile id
   * @return {Promise<ProvisioningProfile>} promise resolving with provisioning profile entity
   */ async getProvisioningProfile(provisioningProfileId) {
        let profile = await this._provisioningProfileClient.getProvisioningProfile(provisioningProfileId);
        return new _provisioningProfile.default(profile, this._provisioningProfileClient);
    }
    /**
   * Creates a provisioning profile
   * @param {NewProvisioningProfileDto} profile provisioning profile data
   * @return {Promise<ProvisioningProfile>} promise resolving with provisioning profile entity
   */ async createProvisioningProfile(profile) {
        let id = await this._provisioningProfileClient.createProvisioningProfile(profile);
        return new _provisioningProfile.default(Object.assign({}, profile, {
            _id: id.id,
            status: "new"
        }), this._provisioningProfileClient);
    }
    /**
   * Constructs a provisioning profile API instance
   * @param {ProvisioningProfileClient} provisioningProfileClient provisioning profile REST API client
   */ constructor(provisioningProfileClient){
        this._provisioningProfileClient = provisioningProfileClient;
    }
};

//# sourceMappingURL=data:application/json;base64,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