"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "default", {
    enumerable: true,
    get: function() {
        return LatencyListener;
    }
});
let LatencyListener = class LatencyListener {
    /**
   * Object containing request latency information
   * @typedef {Object} ResponseTimestamps
   * @property {Date} clientProcessingStarted time when request processing have started on client side
   * @property {Date} serverProcessingStarted time when request processing have started on server side
   * @property {Date} serverProcessingFinished time when request processing have finished on server side
   * @property {Date} clientProcessingFinished time when request processing have finished on client side
   */ /**
   * Invoked with latency information when application receives a response to RPC request
   * @param {string} accountId account id
   * @param {string} type request type
   * @param {ResponseTimestamps} timestamps request timestamps object containing latency information
   * @return {Promise} promise which resolves when latency information is processed
   */ async onResponse(accountId, type, timestamps) {}
    /**
   * Timestamps object containing latency information about price streaming
   * @typedef {Object} SymbolPriceTimestamps
   * @property {Date} eventGenerated time the event was generated on exchange side
   * @property {Date} serverProcessingStarted time the event processing have started on server side
   * @property {Date} serverProcessingFinished time the event processing have finished on server side
   * @property {Date} clientProcessingFinished time the event processing have finished on client side
   */ /**
   * Invoked with latency information when application receives symbol price update event
   * @param {string} accountId account id
   * @param {string} symbol price symbol
   * @param {SymbolPriceTimestamps} timestamps timestamps object containing latency information about price streaming
   * @return {Promise} promise which resolves when latency information is processed
   */ async onSymbolPrice(accountId, symbol, timestamps) {}
    /**
   * Timestamps object containing latency information about update streaming
   * @typedef {Object} UpdateTimestamps
   * @property {Date} eventGenerated time the event was generated on exchange side
   * @property {Date} serverProcessingStarted time the event processing have started on server side
   * @property {Date} serverProcessingFinished time the event processing have finished on server side
   * @property {Date} clientProcessingFinished time the event processing have finished on client side
   */ /**
   * Invoked with latency information when application receives update event
   * @param {string} accountId account id
   * @param {UpdateTimestamps} timestamps timestamps object containing latency information about update streaming
   * @return {Promise} promise which resolves when latency information is processed
   */ async onUpdate(accountId, timestamps) {}
    /**
   * Timestamps object containing latency information about a trade
   * @typedef {Object} TradeTimestamps
   * @property {Date} clientProcessingStarted time when request processing have started on client side
   * @property {Date} serverProcessingStarted time the event processing have started on server side
   * @property {Date} serverProcessingFinished time the event processing have finished on server side
   * @property {Date} clientProcessingFinished time the event processing have finished on client side
   * @property {Date} tradeStarted time the trade execution was started on server side
   * @property {Date} tradeExecuted time the trade was executed on exchange side
   */ /**
   * Invoked with latency information when application receives trade response
   * @param {string} accountId account id
   * @param {TradeTimestamps} timestamps timestamps object containing latency information about a trade
   * @return {Promise} promise which resolves when latency information is processed
   */ async onTrade(accountId, timestamps) {}
};

//# sourceMappingURL=data:application/json;base64,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