'use strict';
function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) {
    try {
        var info = gen[key](arg);
        var value = info.value;
    } catch (error) {
        reject(error);
        return;
    }
    if (info.done) {
        resolve(value);
    } else {
        Promise.resolve(value).then(_next, _throw);
    }
}
function _async_to_generator(fn) {
    return function() {
        var self = this, args = arguments;
        return new Promise(function(resolve, reject) {
            var gen = fn.apply(self, args);
            function _next(value) {
                asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value);
            }
            function _throw(err) {
                asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err);
            }
            _next(undefined);
        });
    };
}
let ExpertAdvisor = class ExpertAdvisor {
    /**
   * Returns expert id
   * @returns {String} expert id
   */ get expertId() {
        return this._data.expertId;
    }
    /**
   * Returns expert period
   * @returns {String} expert period
   */ get period() {
        return this._data.period;
    }
    /**
   * Returns expert symbol
   * @returns {String} expert symbol
   */ get symbol() {
        return this._data.symbol;
    }
    /**
   * Returns true if expert file was uploaded
   * @returns {Boolean}
   */ get fileUploaded() {
        return this._data.fileUploaded;
    }
    /**
   * Reloads expert advisor from API
   * (see https://metaapi.cloud/docs/provisioning/api/expertAdvisor/readExpertAdvisor/)
   * @returns {Promise} promise resolving when expert advisor is updated
   */ reload() {
        var _this = this;
        return _async_to_generator(function*() {
            _this._data = yield _this._expertAdvisorClient.getExpertAdvisor(_this._accountId, _this.expertId);
        })();
    }
    /**
   * Updates expert advisor data
   * (see https://metaapi.cloud/docs/provisioning/api/expertAdvisor/updateExpertAdvisor/)
   * @param {NewExpertAdvisorDto} expert new expert advisor data
   * @returns {Promise} promise resolving when expert advisor is updated
   */ update(expert) {
        var _this = this;
        return _async_to_generator(function*() {
            yield _this._expertAdvisorClient.updateExpertAdvisor(_this._accountId, _this.expertId, expert);
            yield _this.reload();
        })();
    }
    /**
   * Uploads an expert advisor file. EAs which use DLLs are not supported
   * (see https://metaapi.cloud/docs/provisioning/api/expertAdvisor/uploadEAFile/)
   * @param {String|Buffer} file expert advisor file
   * @returns {Promise} promise resolving when file upload is completed
   */ uploadFile(file) {
        var _this = this;
        return _async_to_generator(function*() {
            yield _this._expertAdvisorClient.uploadExpertAdvisorFile(_this._accountId, _this.expertId, file);
            yield _this.reload();
        })();
    }
    /**
   * Removes expert advisor
   * (see https://metaapi.cloud/docs/provisioning/api/expertAdvisor/deleteExpertAdvisor/)
   * @returns {Promise} promise resolving when expert advisor removed
   */ remove() {
        var _this = this;
        return _async_to_generator(function*() {
            yield _this._expertAdvisorClient.deleteExpertAdvisor(_this._accountId, _this.expertId);
        })();
    }
    /**
   * Constructs an expert advisor entity
   * @param {ExpertAdvisorDto} data
   * @param accountId
   * @param expertAdvisorClient
   */ constructor(data, accountId, expertAdvisorClient){
        this._data = data;
        this._accountId = accountId;
        this._expertAdvisorClient = expertAdvisorClient;
    }
};
/**
 * Implements an expert advisor entity
 */ export { ExpertAdvisor as default };

//# sourceMappingURL=data:application/json;base64,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