'use strict';
let MethodAccessError = class MethodAccessError extends Error {
    /**
   * Constructs the error
   * @param {string} methodName Name of method
   * @param {string} accessType Type of method access
   */ constructor(methodName, accessType = 'api'){
        let errorMessage = '';
        switch(accessType){
            case 'api':
                {
                    errorMessage = `You can not invoke ${methodName} method, because you have connected with API access token. ` + 'Please use account access token to invoke this method.';
                    break;
                }
            case 'account':
                {
                    errorMessage = `You can not invoke ${methodName} method, because you have connected with account access token. ` + 'Please use API access token from https://app.metaapi.cloud/api-access/generate-token page ' + 'to invoke this method.';
                    break;
                }
            default:
                {
                    errorMessage = '';
                    break;
                }
        }
        super(errorMessage);
        this.name = 'MethodAccessError';
    }
};
/**
 * Error which indicates that user doesn't have access to a method
 */ export { MethodAccessError as default };

//# sourceMappingURL=data:application/json;base64,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