'use strict';
let TradeError = class TradeError extends Error {
    /**
   * Constructs the error
   * @param {String} message error message
   * @param {Number} numericCode numeric error code
   * @param {String} stringCode string error code
   */ constructor(message, numericCode, stringCode){
        super(message);
        this.name = 'TradeError';
        this.numericCode = numericCode;
        this.stringCode = stringCode;
    }
};
/**
 * Error which indicates that a trade have failed
 */ export { TradeError as default };

//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIjxhbm9uPiJdLCJzb3VyY2VzQ29udGVudCI6WyIndXNlIHN0cmljdCc7XG5cbi8qKlxuICogRXJyb3Igd2hpY2ggaW5kaWNhdGVzIHRoYXQgYSB0cmFkZSBoYXZlIGZhaWxlZFxuICovXG5leHBvcnQgZGVmYXVsdCBjbGFzcyBUcmFkZUVycm9yIGV4dGVuZHMgRXJyb3Ige1xuXG4gIC8qKlxuICAgKiBDb25zdHJ1Y3RzIHRoZSBlcnJvclxuICAgKiBAcGFyYW0ge1N0cmluZ30gbWVzc2FnZSBlcnJvciBtZXNzYWdlXG4gICAqIEBwYXJhbSB7TnVtYmVyfSBudW1lcmljQ29kZSBudW1lcmljIGVycm9yIGNvZGVcbiAgICogQHBhcmFtIHtTdHJpbmd9IHN0cmluZ0NvZGUgc3RyaW5nIGVycm9yIGNvZGVcbiAgICovXG4gIGNvbnN0cnVjdG9yKG1lc3NhZ2UsIG51bWVyaWNDb2RlLCBzdHJpbmdDb2RlKSB7XG4gICAgc3VwZXIobWVzc2FnZSk7XG4gICAgdGhpcy5uYW1lID0gJ1RyYWRlRXJyb3InO1xuICAgIHRoaXMubnVtZXJpY0NvZGUgPSBudW1lcmljQ29kZTtcbiAgICB0aGlzLnN0cmluZ0NvZGUgPSBzdHJpbmdDb2RlO1xuICB9XG5cbn1cbiJdLCJuYW1lcyI6WyJUcmFkZUVycm9yIiwiRXJyb3IiLCJjb25zdHJ1Y3RvciIsIm1lc3NhZ2UiLCJudW1lcmljQ29kZSIsInN0cmluZ0NvZGUiLCJuYW1lIl0sIm1hcHBpbmdzIjoiQUFBQTtBQUtlLElBQUEsQUFBTUEsYUFBTixNQUFNQSxtQkFBbUJDO0lBRXRDOzs7OztHQUtDLEdBQ0RDLFlBQVlDLE9BQU8sRUFBRUMsV0FBVyxFQUFFQyxVQUFVLENBQUU7UUFDNUMsS0FBSyxDQUFDRjtRQUNOLElBQUksQ0FBQ0csSUFBSSxHQUFHO1FBQ1osSUFBSSxDQUFDRixXQUFXLEdBQUdBO1FBQ25CLElBQUksQ0FBQ0MsVUFBVSxHQUFHQTtJQUNwQjtBQUVGO0FBbEJBOztDQUVDLEdBQ0QsU0FBcUJMLHdCQWVwQiJ9