"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "default", {
    enumerable: true,
    get: function() {
        return EquityChartListener;
    }
});
let EquityChartListener = class EquityChartListener {
    /**
   * Returns account id
   */ get accountId() {
        return this._accountId;
    }
    /**
   * Processes equity chart event which occurs when new equity chart data arrives
   * @param {EquityChartItem[]} equityChartEvent equity chart event
   */ async onEquityRecordUpdated(equityChartEvent) {
        throw Error("Abstract method onEquityChartEvent has no implementation");
    }
    /**
   * Processes equity chart event which occurs when an equity chart period ends
   */ async onEquityRecordCompleted() {
        throw Error("Abstract method onEquityRecordCompleted has no implementation");
    }
    /**
   * Processes an event which occurs when connection has been established
   */ async onConnected() {
        throw Error("Abstract method onConnected has no implementation");
    }
    /**
   * Processes an event which occurs when connection has been lost
   */ async onDisconnected() {
        throw Error("Abstract method onDisconnected has no implementation");
    }
    /**
   * Processes an error event
   * @param {Error} error error received 
   */ async onError(error) {}
    /**
   * Creates an equity chart listener instance
   * @param {string} accountId account id
   */ constructor(accountId){
        if (!accountId) {
            throw Error("Account id parameter required");
        }
        this._accountId = accountId;
    }
};

//# sourceMappingURL=data:application/json;base64,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