"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    assembleLog4jsConfig: function() {
        return assembleLog4jsConfig;
    },
    createHandlePromise: function() {
        return createHandlePromise;
    },
    delay: function() {
        return delay;
    }
});
const _timeoutError = /*#__PURE__*/ _interop_require_default(require("../clients/timeoutError"));
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
function createHandlePromise() {
    let resolve, reject;
    let promise = new Promise((res, rej)=>{
        resolve = res;
        reject = rej;
    });
    promise.resolve = (result)=>{
        if (promise.completed) {
            return;
        }
        promise.resolved = true;
        promise.completed = true;
        resolve(result);
    };
    promise.reject = (err)=>{
        if (promise.completed) {
            return;
        }
        promise.rejected = true;
        promise.completed = true;
        reject(err);
    };
    promise.timeout = (milliseconds, errorMessage)=>{
        if (promise.completed) {
            return;
        }
        let timeout = setTimeout(()=>promise.reject(new _timeoutError.default(errorMessage)), milliseconds);
        promise.finally(()=>clearTimeout(timeout)).catch(()=>{});
        return promise;
    };
    promise.catch(()=>{});
    return promise;
}
function delay(ms) {
    return new Promise((res)=>setTimeout(res, ms));
}
function assembleLog4jsConfig(config = {}) {
    let appenders = {
        console: {
            type: "console"
        }
    };
    let categories = {
        default: {
            appenders: Object.keys(appenders),
            level: config.defaultLevel || "INFO"
        }
    };
    Object.keys(config.levels || {}).forEach((category)=>{
        categories[category] = {
            appenders: Object.keys(appenders),
            level: config.levels[category]
        };
    });
    return {
        appenders,
        categories
    };
}

//# sourceMappingURL=data:application/json;base64,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