"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, /**
 * MetaStats API SDK
 */ "default", {
    enumerable: true,
    get: function() {
        return MetaStats;
    }
});
const _httpClient = /*#__PURE__*/ _interop_require_default(require("./clients/httpClient"));
const _domainclient = /*#__PURE__*/ _interop_require_default(require("./clients/domain.client"));
const _metaStatsclient = /*#__PURE__*/ _interop_require_default(require("./clients/metaStats.client"));
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
let MetaStats = class MetaStats {
    _metaStatsClient;
    /**
   * Constructs MetaStats class instance
   * @param {String} token authorization token
   * @param {ConnectionOptions} [opts] connection options
   */ constructor(token, opts = {}){
        const httpClient = new _httpClient.default(opts.requestTimeout, opts.retryOpts);
        const domainClient = new _domainclient.default(httpClient, token, opts.domain);
        this._metaStatsClient = new _metaStatsclient.default(domainClient);
    }
    /**
   * Returns the getMetrics MetaStatsClient method bound to the MetaStatsClient instance
   * @returns {Function} getMetrics MetaStatsClient method
   */ get getMetrics() {
        return this._metaStatsClient.getMetrics.bind(this._metaStatsClient);
    }
    /**
   * Returns the getAccountTrades MetaStatsClient method bound to the MetaStatsClient instance
   * @returns {Function} getAccountTrades MetaStatsClient method
   */ get getAccountTrades() {
        return this._metaStatsClient.getAccountTrades.bind(this._metaStatsClient);
    }
    /**
   * Returns the getAccountOpenTrades MetaStatsClient method bound to the MetaStatsClient instance
   * @returns {Function} getAccountOpenTrades MetaStatsClient method
   */ get getAccountOpenTrades() {
        return this._metaStatsClient.getAccountOpenTrades.bind(this._metaStatsClient);
    }
    /**
   * Returns the resetMetrics MetaStatsClient method bound to the MetaStatsClient instance
   * @returns {Function} resetMetrics MetaStatsClient method
   */ get resetMetrics() {
        return this._metaStatsClient.resetMetrics.bind(this._metaStatsClient);
    }
};

//# sourceMappingURL=data:application/json;base64,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