'use strict';
function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) {
    try {
        var info = gen[key](arg);
        var value = info.value;
    } catch (error) {
        reject(error);
        return;
    }
    if (info.done) {
        resolve(value);
    } else {
        Promise.resolve(value).then(_next, _throw);
    }
}
function _async_to_generator(fn) {
    return function() {
        var self = this, args = arguments;
        return new Promise(function(resolve, reject) {
            var gen = fn.apply(self, args);
            function _next(value) {
                asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value);
            }
            function _throw(err) {
                asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err);
            }
            _next(undefined);
        });
    };
}
function _define_property(obj, key, value) {
    if (key in obj) {
        Object.defineProperty(obj, key, {
            value: value,
            enumerable: true,
            configurable: true,
            writable: true
        });
    } else {
        obj[key] = value;
    }
    return obj;
}
export * from './metaStats.client.schemas';
let MetaStatsClient = class MetaStatsClient {
    /**
   * Returns metrics of MetaApi account. This API call is billable
   * https://metaapi.cloud/docs/metastats/restApi/api/calculateMetrics/
   * @param {String} accountId MetaApi account id
   * @param {Boolean} [includeOpenPositions] indicates whether open positions will be included
   * in the metrics, default false
   * @return {Metrics} account metrics
   */ getMetrics(accountId, includeOpenPositions = false) {
        var _this = this;
        return _async_to_generator(function*() {
            const getOpts = (host, id)=>({
                    url: host + `/users/current/accounts/${id}/metrics`,
                    method: 'GET',
                    headers: {
                        'auth-token': _this._domainClient.token
                    },
                    params: {
                        includeOpenPositions
                    },
                    json: true
                });
            const { metrics } = yield _this._domainClient.requestMetastats(getOpts, accountId);
            return metrics;
        })();
    }
    /**
   * Returns historical trades of MetaApi account
   * https://metaapi.cloud/docs/metastats/restApi/api/getHistoricalTrades/
   * @param {String} accountId MetaApi account id
   * @param {String} startTime start of time range, inclusive
   * @param {String} endTime end of time range, exclusive
   * @param {Boolean} [updateHistory] update historical trades before returning results. 
   * If set to true, the API call will be counted towards billable MetaStats API calls. 
   * If set to false, the API call is not billable. Default is true
   * @param {Number} [limit] pagination limit
   * @param {Number} [offset] pagination offset
   * @param {Number} [marketValue ] trade market value
   * @return {Array<Trade>} account historical trades
   */ getAccountTrades(accountId, startTime, endTime, updateHistory = true, limit = 1000, offset = 0) {
        var _this = this;
        return _async_to_generator(function*() {
            const getOpts = (host, id)=>({
                    url: host + `/users/current/accounts/${id}/historical-trades/${startTime}/${endTime}`,
                    method: 'GET',
                    headers: {
                        'auth-token': _this._domainClient.token
                    },
                    params: {
                        updateHistory,
                        limit,
                        offset
                    },
                    json: true
                });
            const { trades } = yield _this._domainClient.requestMetastats(getOpts, accountId);
            return trades;
        })();
    }
    /**
   * Returns open trades of MetaApi account. This API call is not billable
   * https://metaapi.cloud/docs/metastats/restApi/api/getOpenTrades/
   * @param {String} accountId MetaApi account id
   * @param {Number} [marketValue] trade market value
   * @return {Array<OpenTrade>} account historical trades
   */ getAccountOpenTrades(accountId) {
        var _this = this;
        return _async_to_generator(function*() {
            const getOpts = (host, id)=>({
                    url: host + `/users/current/accounts/${id}/open-trades`,
                    method: 'GET',
                    headers: {
                        'auth-token': _this._domainClient.token
                    },
                    json: true
                });
            const { openTrades } = yield _this._domainClient.requestMetastats(getOpts, accountId);
            return openTrades;
        })();
    }
    /**
   * Resets metrics and trade history for a trading account from MetaStats. The data will be downloaded from trading
   * account again when you calculate the MetaStats metrics next time. This API call is not billable
   * @param accountId MetaApi account id
   * @return promise resolving when removed
   */ resetMetrics(accountId) {
        var _this = this;
        return _async_to_generator(function*() {
            const getOpts = (host, id)=>({
                    url: host + `/users/current/accounts/${id}`,
                    method: 'DELETE',
                    headers: {
                        'auth-token': _this._domainClient.token
                    },
                    json: true
                });
            return _this._domainClient.requestMetastats(getOpts, accountId);
        })();
    }
    /**
   * Constructs MetaStats API client instance
   * @param {DomainClient} domainClient domain client
   */ constructor(domainClient){
        _define_property(this, "_domainClient", void 0);
        this._domainClient = domainClient;
    }
};
/**
 * metaapi.cloud MetaStats MetaTrader API client
 */ export { MetaStatsClient as default };

//# sourceMappingURL=data:application/json;base64,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