"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, /**
 * CopyFactory client for signal requests
 */ "default", {
    enumerable: true,
    get: function() {
        return SubscriberSignalClient;
    }
});
let SubscriberSignalClient = class SubscriberSignalClient {
    /**
   * Constructs CopyFactory signal client instance
   * @param {string} accountId account id
   * @param {Object} host host data
   * @param {DomainClient} domainClient domain client
   */ constructor(accountId, host, domainClient){
        this._accountId = accountId;
        this._domainClient = domainClient;
        this._host = host;
    }
    /**
   * CopyFactory trading signal
   * @typedef {Object} CopyFactoryTradingSignal
   * @property {CopyFactoryStrategyIdAndName} strategy strategy the signal arrived from
   * @property {String} positionId id of the position the signal was generated from
   * @property {Date} time signal time
   * @property {String} symbol symbol traded
   * @property {String} type type of the trade (one of market, limit, stop)
   * @property {String} side side of the trade (one of buy, sell, close)
   * @property {Number} [openPrice] open price for limit and stop orders
   * @property {Number} [stopLoss] stop loss price
   * @property {Number} [takeProfit] take profit price
   * @property {Number} signalVolume the signal volume
   * @property {Number} subscriberVolume the volume already open on subscriber side
   * @property {Number} subscriberProfit total profit of the position on subscriber side
   * @property {Date} closeAfter the time the signal will be automatically closed at
   * @property {Boolean} [closeOnly] flag indicating that only closing side of this signal will be copied
   */ /**
   * Returns trading signals the subscriber is subscribed to. See
   * https://metaapi.cloud/docs/copyfactory/restApi/api/trading/getTradingSignals/
   * @returns {Promise<Array<CopyFactoryTradingSignal>>}
   */ getTradingSignals() {
        const opts = {
            url: `/users/current/subscribers/${this._accountId}/signals`,
            method: "GET",
            headers: {
                "auth-token": this._domainClient.token
            },
            json: true
        };
        return this._domainClient.requestSignal(opts, this._host, this._accountId);
    }
};

//# sourceMappingURL=data:application/json;base64,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