import { CopyFactoryStrategyIdAndName } from './history.client';
import DomainClient from '../domain.client';

/**
 * CopyFactory client for signal requests
 */
export default class SubscriberSignalClient {

  /**
   * Constructs CopyFactory signal client instance
   * @param {string} accountId account id
   * @param {Object} host host data
   * @param {DomainClient} domainClient domain client
   */
  constructor(accountId: string, host: Object, domainClient: DomainClient);

  /**
   * Returns trading signals the subscriber is subscribed to. See
   * https://metaapi.cloud/docs/copyfactory/restApi/api/trading/getTradingSignals/
   * @returns {Promise<Array<CopyFactoryTradingSignal>>}
   */
  getTradingSignals(): Promise<Array<CopyFactoryTradingSignal>>;

}

/**
 * CopyFactory trading signal
 */
export declare type CopyFactoryTradingSignal = {

  /**
   * strategy the signal arrived from
   */
  strategy: CopyFactoryStrategyIdAndName,

  /**
   * id of the position the signal was generated from
   */
  positionId: string,

  /**
   * signal time
   */
  time: Date,

  /**
   * symbol traded
   */
  symbol: string,

  /**
   * type of the trade (one of market, limit, stop)
   */
  type: string,

  /**
   * side of the trade (one of buy, sell, close)
   */
  side: string,

  /**
   * open price for limit and stop orders
   */
  openPrice?: number,

  /**
   * stop loss price
   */
  stopLoss?: number,

  /**
   * take profit price
   */
  takeProfit?: number,

  /**
   * the signal volume
   */
  signalVolume: number,

  /**
   * the volume already open on subscriber side
   */
  subscriberVolume: number,

  /**
   * total profit of the position on subscriber side
   */
  subscriberProfit: number,

  /**
   * the time the signal will be automatically closed at
   */
  closeAfter: Date,

  /**
   * flag indicating that only closing side of this signal will be copied
   */
  closeOnly?: boolean
}
