"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, /**
 * User log listener for handling a stream of user log events
 */ "default", {
    enumerable: true,
    get: function() {
        return UserLogListener;
    }
});
let UserLogListener = class UserLogListener {
    /**
   * Calls a predefined function with the packets data
   * @param {CopyFactoryUserLogMessage[]} logEvent user log event with an array of packets
   */ async onUserLog(logEvent) {
        throw Error("Abstract method onUserLog has no implementation");
    }
    /**
   * Calls a predefined function with the received error
   * @param {Error} error error received during retrieve attempt
   */ async onError(error) {}
};

//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIjxhbm9uPiJdLCJzb3VyY2VzQ29udGVudCI6WyIndXNlIHN0cmljdCc7XG5cbi8qKlxuICogVXNlciBsb2cgbGlzdGVuZXIgZm9yIGhhbmRsaW5nIGEgc3RyZWFtIG9mIHVzZXIgbG9nIGV2ZW50c1xuICovXG5leHBvcnQgZGVmYXVsdCBjbGFzcyBVc2VyTG9nTGlzdGVuZXIge1xuXG4gIC8qKlxuICAgKiBDYWxscyBhIHByZWRlZmluZWQgZnVuY3Rpb24gd2l0aCB0aGUgcGFja2V0cyBkYXRhXG4gICAqIEBwYXJhbSB7Q29weUZhY3RvcnlVc2VyTG9nTWVzc2FnZVtdfSBsb2dFdmVudCB1c2VyIGxvZyBldmVudCB3aXRoIGFuIGFycmF5IG9mIHBhY2tldHNcbiAgICovXG4gIGFzeW5jIG9uVXNlckxvZyhsb2dFdmVudCkge1xuICAgIHRocm93IEVycm9yKCdBYnN0cmFjdCBtZXRob2Qgb25Vc2VyTG9nIGhhcyBubyBpbXBsZW1lbnRhdGlvbicpO1xuICB9XG5cbiAgLyoqXG4gICAqIENhbGxzIGEgcHJlZGVmaW5lZCBmdW5jdGlvbiB3aXRoIHRoZSByZWNlaXZlZCBlcnJvclxuICAgKiBAcGFyYW0ge0Vycm9yfSBlcnJvciBlcnJvciByZWNlaXZlZCBkdXJpbmcgcmV0cmlldmUgYXR0ZW1wdFxuICAgKi9cbiAgYXN5bmMgb25FcnJvcihlcnJvcikge31cblxufSJdLCJuYW1lcyI6WyJVc2VyTG9nTGlzdGVuZXIiLCJvblVzZXJMb2ciLCJsb2dFdmVudCIsIkVycm9yIiwib25FcnJvciIsImVycm9yIl0sIm1hcHBpbmdzIjoiQUFBQTs7OzsrQkFFQTs7Q0FFQyxHQUNEOzs7ZUFBcUJBOzs7QUFBTixJQUFBLEFBQU1BLGtCQUFOLE1BQU1BO0lBRW5COzs7R0FHQyxHQUNELE1BQU1DLFVBQVVDLFFBQVEsRUFBRTtRQUN4QixNQUFNQyxNQUFNLG1EQUFtRDtJQUNqRTtJQUVBOzs7R0FHQyxHQUNELE1BQU1DLFFBQVFDLEtBQUssRUFBRSxDQUFDO0FBRXhCIn0=