/* jscs:disable */ /* eslint-disable */ 'use strict';
function createNewNode_(key) {
    return {
        key: key,
        weight: 1,
        height: 0,
        left: null,
        right: null
    };
}
var comparer_ = function(a, b) {
    if (a < b) return -1;
    if (a > b) return 1;
    return 0;
};
function height_(p) {
    return p ? p.height : 0;
}
function weight_(p) {
    return p ? p.weight : 0;
}
function bFactor_(p) {
    return height_(p.right) - height_(p.left);
}
function countHeightAndWeight_(p) {
    var hl = height_(p.left);
    var hr = height_(p.right);
    p.height = (hl > hr ? hl : hr) + 1;
    var wl = weight_(p.left);
    var wr = weight_(p.right);
    p.weight = wl + wr + 1;
}
function rotateRight_(p) {
    var q = p.left;
    p.left = q.right;
    q.right = p;
    countHeightAndWeight_(p);
    countHeightAndWeight_(q);
    return q;
}
function rotateLeft_(q) {
    var p = q.right;
    q.right = p.left;
    p.left = q;
    countHeightAndWeight_(q);
    countHeightAndWeight_(p);
    return p;
}
function balance_(p) {
    countHeightAndWeight_(p);
    if (bFactor_(p) === 2) {
        if (bFactor_(p.right) < 0) p.right = rotateRight_(p.right);
        return rotateLeft_(p);
    }
    if (bFactor_(p) === -2) {
        if (bFactor_(p.left) > 0) p.left = rotateLeft_(p.left);
        return rotateRight_(p);
    }
    return p;
}
function count_(p, k) {
    return upperBound_(p, k) - lowerBound_(p, k);
}
function at_(p, k) {
    if (!p) return null;
    var wl = weight_(p.left);
    if (wl <= k && k < wl + 1) return p.key;
    else if (k < wl) return at_(p.left, k);
    else return at_(p.right, k - wl - 1);
}
function getMinimum_(p) {
    if (!p) return null;
    return p.left ? getMinimum_(p.left) : p;
}
function getMaximum_(p) {
    if (!p) return null;
    return p.right ? getMaximum_(p.right) : p;
}
function removeMinimun_(p) {
    if (!p.left) return p.right;
    p.left = removeMinimun_(p.left);
    return balance_(p);
}
function toArray_(p) {
    var arr = [];
    if (p.left) arr = arr.concat(toArray_(p.left));
    arr.push(p.key);
    if (p.right) arr = arr.concat(toArray_(p.right));
    return arr;
}
var AVLTree = function(comparer) {
    if (!comparer) comparer = comparer_;
    var AVL = {
        root: null,
        comparer_: comparer,
        size: function() {
            return weight_(AVL.root);
        },
        min: function() {
            var p = getMinimum_(AVL.root);
            if (p) return p.key;
            return null;
        },
        max: function() {
            var p = getMaximum_(AVL.root);
            if (p) return p.key;
            return null;
        },
        lowerBound: function(k) {
            return AVL.lowerBound_(AVL.root, k);
        },
        lowerBound_ (p, k) {
            if (!p) return 0;
            var cmp = AVL.comparer_(k, p.key);
            if (cmp <= 0) return AVL.lowerBound_(p.left, k);
            else if (cmp > 0) return weight_(p.left) + AVL.lowerBound_(p.right, k) + 1;
        },
        upperBound: function(k) {
            return AVL.upperBound_(AVL.root, k);
        },
        upperBound_ (p, k) {
            if (!p) return 0;
            var cmp = AVL.comparer_(k, p.key);
            if (cmp < 0) return AVL.upperBound_(p.left, k);
            else if (cmp >= 0) return weight_(p.left) + AVL.upperBound_(p.right, k) + 1;
        },
        count: function(k) {
            return count_(AVL.root, k);
        },
        at: function(k) {
            return at_(AVL.root, k);
        },
        insert: function(k) {
            AVL.root = AVL.insert_(AVL.root, k);
        },
        insert_ (p, k) {
            if (!p) return createNewNode_(k);
            var cmp = AVL.comparer_(k, p.key);
            if (cmp < 0) p.left = AVL.insert_(p.left, k);
            else if (cmp >= 0) p.right = AVL.insert_(p.right, k);
            return balance_(p);
        },
        remove: function(k) {
            AVL.root = AVL.remove_(AVL.root, k);
        },
        remove_ (p, k) {
            if (!p) return null;
            var cmp = AVL.comparer_(k, p.key);
            if (cmp < 0) p.left = AVL.remove_(p.left, k);
            else if (cmp > 0) p.right = AVL.remove_(p.right, k);
            else {
                var q = p.left;
                var r = p.right;
                if (!r) return q;
                var min = getMinimum_(r);
                min.right = removeMinimun_(r);
                min.left = q;
                return balance_(min);
            }
            return balance_(p);
        },
        removeAt: function(k) {
            var val = AVL.at(k);
            AVL.root = AVL.remove_(AVL.root, val);
        },
        toArray: function() {
            if (AVL.root === null) return [];
            return toArray_(AVL.root);
        }
    };
    return AVL;
};
export default AVLTree;

//# sourceMappingURL=data:application/json;base64,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