'use strict';
let MetatraderAccountCredentials = class MetatraderAccountCredentials {
    /**
   * Returns account login
   * @return {String} account login
   */ get login() {
        return this._data.login;
    }
    /**
   * Returns account password
   * @return {String} account password
   */ get password() {
        return this._data.password;
    }
    /**
   * Returns account serverName
   * @return {String} account serverName
   */ get serverName() {
        return this._data.serverName;
    }
    /**
   * Returns account investor password
   * @return {String} account investor password
   */ get investorPassword() {
        return this._data.investorPassword;
    }
    /**
   * Constructs a MetaTrader account credentials entity
   * @param {MetatraderAccountCredentialsDto} data MetaTrader account credentials data
   */ constructor(data){
        this._data = data;
    }
};
/**
 * Implements a MetaTrader account credentials entity
 */ export { MetatraderAccountCredentials as default };

//# sourceMappingURL=data:application/json;base64,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