'use strict';
function _define_property(obj, key, value) {
    if (key in obj) {
        Object.defineProperty(obj, key, {
            value: value,
            enumerable: true,
            configurable: true,
            writable: true
        });
    } else {
        obj[key] = value;
    }
    return obj;
}
function _object_spread(target) {
    for(var i = 1; i < arguments.length; i++){
        var source = arguments[i] != null ? arguments[i] : {};
        var ownKeys = Object.keys(source);
        if (typeof Object.getOwnPropertySymbols === "function") {
            ownKeys = ownKeys.concat(Object.getOwnPropertySymbols(source).filter(function(sym) {
                return Object.getOwnPropertyDescriptor(source, sym).enumerable;
            }));
        }
        ownKeys.forEach(function(key) {
            _define_property(target, key, source[key]);
        });
    }
    return target;
}
function ownKeys(object, enumerableOnly) {
    var keys = Object.keys(object);
    if (Object.getOwnPropertySymbols) {
        var symbols = Object.getOwnPropertySymbols(object);
        if (enumerableOnly) {
            symbols = symbols.filter(function(sym) {
                return Object.getOwnPropertyDescriptor(object, sym).enumerable;
            });
        }
        keys.push.apply(keys, symbols);
    }
    return keys;
}
function _object_spread_props(target, source) {
    source = source != null ? source : {};
    if (Object.getOwnPropertyDescriptors) {
        Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
    } else {
        ownKeys(Object(source)).forEach(function(key) {
            Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
        });
    }
    return target;
}
import MetaApiClient from '../metaApi.client';
import FormData from 'form-data';
import fs from 'fs';
let ExpertAdvisorClient = class ExpertAdvisorClient extends MetaApiClient {
    /**
   * Expert advisor model
   * @typedef {Object} ExpertAdvisorDto
   * @property {String} expertId expert advisor id
   * @property {String} period expert advisor period
   * @property {String} symbol expert advisor symbol
   * @property {Boolean} fileUploaded true if expert file was uploaded
   */ /**
   * Retrieves expert advisors by account id (see
   * https://metaapi.cloud/docs/provisioning/api/expertAdvisor/readExpertAdvisors/)
   * Method is accessible only with API access token
   * @param {String} accountId Metatrader account id
   * @returns {Promise<ExpertAdvisorDto[]>} promise resolving with expert advisors found
   */ getExpertAdvisors(accountId) {
        if (this._isNotJwtToken()) {
            return this._handleNoAccessError('getExpertAdvisors');
        }
        const opts = {
            url: `${this._host}/users/current/accounts/${accountId}/expert-advisors`,
            method: 'GET',
            headers: {
                'auth-token': this._token
            },
            json: true
        };
        return this._httpClient.request(opts, 'getExpertAdvisors');
    }
    /**
   * Retrieves an expert advisor by id (see
   * https://metaapi.cloud/docs/provisioning/api/expertAdvisor/readExpertAdvisor/).
   * Thrown an error if expert is not found. Method is accessible only with API access token
   * @param {String} accountId Metatrader account id
   * @param {String} expertId expert advisor id
   * @returns {Promise<ExpertAdvisorDto>} promise resolving with expert advisor found
   */ getExpertAdvisor(accountId, expertId) {
        if (this._isNotJwtToken()) {
            return this._handleNoAccessError('getExpertAdvisor');
        }
        const opts = {
            url: `${this._host}/users/current/accounts/${accountId}/expert-advisors/${expertId}`,
            method: 'GET',
            headers: {
                'auth-token': this._token
            },
            json: true
        };
        return this._httpClient.request(opts, 'getExpertAdvisor');
    }
    /**
   * Updated expert advisor data
   * @typedef {Object} NewExpertAdvisorDto
   * @property {String} period expert advisor symbol.
   * For MetaTrader 4 allowed periods are 1m, 5m, 15m, 30m, 1h, 4h, 1d, 1w, 1mn
   * For MetaTrader 5 allowed periods are 1m, 2m, 3m, 4m, 5m, 6m, 10m, 12m, 15m, 20m, 30m, 1h, 2h, 3h, 4h, 6h, 8h, 12h,
   * 1d, 1w, 1mn
   * @property {String} symbol expert advisor period
   * @property {String} preset base64-encoded preset file
   */ /**
   * Updates or creates expert advisor data (see
   * https://metaapi.cloud/docs/provisioning/api/expertAdvisor/updateExpertAdvisor/).
   * Method is accessible only with API access token
   * @param {String} accountId Metatrader account id
   * @param {String} expertId expert id
   * @param {NewExpertAdvisorDto} expert new expert advisor data
   * @returns {Promise} promise resolving when expert advisor is updated
   */ updateExpertAdvisor(accountId, expertId, expert) {
        if (this._isNotJwtToken()) {
            return this._handleNoAccessError('updateExpertAdvisor');
        }
        const opts = {
            url: `${this._host}/users/current/accounts/${accountId}/expert-advisors/${expertId}`,
            method: 'PUT',
            headers: {
                'auth-token': this._token
            },
            json: true,
            data: expert
        };
        return this._httpClient.request(opts, 'updateExpertAdvisor');
    }
    /**
   * Uploads an expert advisor file (see https://metaapi.cloud/docs/provisioning/api/expertAdvisor/uploadEAFile/)
   * Method is accessible only with API access token
   * @param {String} accountId Metatrader account id
   * @param {String} expertId expert id
   * @param {String|Buffer} file path to a file to upload or buffer containing file contents
   * @returns {Promise} promise resolving when file upload is completed
   */ uploadExpertAdvisorFile(accountId, expertId, file) {
        if (this._isNotJwtToken()) {
            return this._handleNoAccessError('uploadExpertAdvisorFile');
        }
        if (typeof file === 'string') {
            file = fs.createReadStream(file);
        }
        const formData = new FormData();
        formData.append('file', file);
        const opts = {
            method: 'PUT',
            url: `${this._host}/users/current/accounts/${accountId}/expert-advisors/${expertId}/file`,
            data: formData,
            headers: _object_spread_props(_object_spread({}, formData.getHeaders()), {
                'auth-token': this._token
            })
        };
        return this._httpClient.request(opts, 'uploadExpertAdvisorFile');
    }
    /**
   * Deletes an expert advisor (see https://metaapi.cloud/docs/provisioning/api/expertAdvisor/deleteExpertAdvisor/)
   * Method is accessible only with API access token
   * @param {String} accountId Metatrader account id
   * @param {String} expertId expert id
   * @returns {Promise} promise resolving when expert advisor is deleted
   */ deleteExpertAdvisor(accountId, expertId) {
        if (this._isNotJwtToken()) {
            return this._handleNoAccessError('deleteExpertAdvisor');
        }
        const opts = {
            url: `${this._host}/users/current/accounts/${accountId}/expert-advisors/${expertId}`,
            method: 'DELETE',
            headers: {
                'auth-token': this._token
            },
            json: true
        };
        return this._httpClient.request(opts, 'deleteExpertAdvisor');
    }
};
/**
 * metaapi.cloud expert advisor API client (see https://metaapi.cloud/docs/provisioning/)
 */ export { ExpertAdvisorClient as default };

//# sourceMappingURL=data:application/json;base64,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