'use strict';
function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) {
    try {
        var info = gen[key](arg);
        var value = info.value;
    } catch (error) {
        reject(error);
        return;
    }
    if (info.done) {
        resolve(value);
    } else {
        Promise.resolve(value).then(_next, _throw);
    }
}
function _async_to_generator(fn) {
    return function() {
        var self = this, args = arguments;
        return new Promise(function(resolve, reject) {
            var gen = fn.apply(self, args);
            function _next(value) {
                asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value);
            }
            function _throw(err) {
                asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err);
            }
            _next(undefined);
        });
    };
}
import LoggerManager from '../logger';
let DomainClient = class DomainClient {
    /**
   * Returns domain client domain
   * @returns {String} client domain
   */ get domain() {
        return this._domain;
    }
    /**
   * Returns domain client token
   * @returns {String} client token
   */ get token() {
        return this._token;
    }
    /**
   * Returns the API URL
   * @param {String} host REST API host
   * @param {String} region host region
   * @returns {String} API URL
   */ getUrl(host, region) {
        var _this = this;
        return _async_to_generator(function*() {
            yield _this._updateDomain();
            return `${host}.${region}.${_this._urlCache.domain}`;
        })();
    }
    /**
   * Domain settings
   * @typedef {Object} DomainSettings
   * @property {String} hostname client api host name
   * @property {String} domain client api domain for regions
   */ /**
   * Returns domain settings
   * @returns {DomainSettings} domain settings
   */ getSettings() {
        var _this = this;
        return _async_to_generator(function*() {
            yield _this._updateDomain();
            return {
                domain: _this._urlCache.domain,
                hostname: _this._urlCache.hostname
            };
        })();
    }
    _updateDomain() {
        var _this = this;
        return _async_to_generator(function*() {
            if (!_this._urlCache.domain || _this._urlCache.lastUpdated < Date.now() - 1000 * 60 * 10) {
                if (_this._urlCache.requestPromise) {
                    yield _this._urlCache.requestPromise;
                } else {
                    let resolve, reject;
                    _this._urlCache.requestPromise = new Promise((res, rej)=>{
                        resolve = res, reject = rej;
                    });
                    let isCacheUpdated = false;
                    while(!isCacheUpdated){
                        const opts = {
                            url: `https://mt-provisioning-api-v1.${_this._domain}/users/current/servers/mt-client-api`,
                            method: 'GET',
                            headers: {
                                'auth-token': _this._token
                            },
                            json: true
                        };
                        try {
                            const urlSettings = yield _this._httpClient.request(opts, '_updateDomain');
                            _this._urlCache = {
                                domain: urlSettings.domain,
                                hostname: urlSettings.hostname,
                                requestPromise: null,
                                lastUpdated: Date.now()
                            };
                            resolve();
                            isCacheUpdated = true;
                            _this._retryIntervalInSeconds = 1;
                        } catch (err) {
                            _this._logger.error('Failed to update domain settings cache', err);
                            _this._retryIntervalInSeconds = Math.min(_this._retryIntervalInSeconds * 2, 300);
                            yield new Promise((res)=>setTimeout(res, _this._retryIntervalInSeconds * 1000));
                        }
                    }
                }
            }
        })();
    }
    /**
   * Constructs domain client instance
   * @param {HttpClient} httpClient HTTP client
   * @param {String} token authorization token
   * @param {String} domain domain to connect to, default is agiliumtrade.agiliumtrade.ai
   */ constructor(httpClient, token, domain = 'agiliumtrade.agiliumtrade.ai'){
        this._httpClient = httpClient;
        this._domain = domain;
        this._token = token;
        this._urlCache = {
            domain: null,
            hostname: null,
            requestPromise: null,
            lastUpdated: 0
        };
        this._retryIntervalInSeconds = 1;
        this._logger = LoggerManager.getLogger('DomainClient');
    }
};
/**
 * Connection URL managing client
 */ export { DomainClient as default };

//# sourceMappingURL=data:application/json;base64,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