"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    ConditionPromise: function() {
        return ConditionPromise;
    },
    HandlePromise: function() {
        return HandlePromise;
    }
});
const _helpers = /*#__PURE__*/ _interop_require_wildcard(require("./helpers"));
function _getRequireWildcardCache(nodeInterop) {
    if (typeof WeakMap !== "function") return null;
    var cacheBabelInterop = new WeakMap();
    var cacheNodeInterop = new WeakMap();
    return (_getRequireWildcardCache = function(nodeInterop) {
        return nodeInterop ? cacheNodeInterop : cacheBabelInterop;
    })(nodeInterop);
}
function _interop_require_wildcard(obj, nodeInterop) {
    if (!nodeInterop && obj && obj.__esModule) {
        return obj;
    }
    if (obj === null || typeof obj !== "object" && typeof obj !== "function") {
        return {
            default: obj
        };
    }
    var cache = _getRequireWildcardCache(nodeInterop);
    if (cache && cache.has(obj)) {
        return cache.get(obj);
    }
    var newObj = {
        __proto__: null
    };
    var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;
    for(var key in obj){
        if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) {
            var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;
            if (desc && (desc.get || desc.set)) {
                Object.defineProperty(newObj, key, desc);
            } else {
                newObj[key] = obj[key];
            }
        }
    }
    newObj.default = obj;
    if (cache) {
        cache.set(obj, newObj);
    }
    return newObj;
}
let HandlePromise = class HandlePromise {
    /**
   * Returns whether the promise has resolved
   * @returns {boolean} whether the promise has resolved
   */ get resolved() {
        return !!this._promise.resolved;
    }
    /**
   * Returns whether the promise has rejected
   * @returns {boolean} whether the promise has rejected
   */ get rejected() {
        return !!this._promise.rejected;
    }
    /**
   * Returns whether the promise has completed (either resolved or rejected)
   * @returns {boolean} whether the promise has completed (either resolved or rejected)
   */ get completed() {
        return !!this._promise.completed;
    }
    /**
   * Constructs instance
   * @param {Promise<T>} [promise] original promise to wrap into the handle
   */ constructor(promise){
        this._promise = _helpers.createHandlePromise();
        this.then = this._promise.then.bind(this._promise);
        this.catch = this._promise.catch.bind(this._promise);
        this.finally = this._promise.finally.bind(this._promise);
        this.resolve = this._promise.resolve.bind(this._promise);
        this.reject = this._promise.reject.bind(this._promise);
        this.timeout = this._promise.timeout.bind(this._promise);
        if (promise) {
            promise.then(this.resolve).catch(()=>{});
            promise.catch(this.reject);
        }
    }
};
let ConditionPromise = class ConditionPromise extends HandlePromise {
    /**
   * Calls the predicate to check if the promise should be resolved
   */ check() {
        if (this._predicate()) {
            this.resolve();
        }
    }
    /**
   * Constructs instance
   * @param {() => boolean} predicate function that returns true when the condition is reached
   */ constructor(predicate){
        super();
        this._predicate = predicate;
        this.check();
    }
};

//# sourceMappingURL=data:application/json;base64,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