import {CopyFactoryStrategyIdAndName} from './history.client';

/**
 * CopyFactory strategy stopout reason
 */
export declare type CopyFactoryStrategyStopoutReason = 'day-balance-difference' | 'date-balance-difference' |
    'week-balance-difference' | 'week-to-date-balance-difference' |
    'month-balance-difference' | 'month-to-date-balance-difference' | 'quarter-balance-difference' |
    'quarter-to-date-balance-difference' | 'year-balance-difference' |
    'year-to-date-balance-difference' | 'lifetime-balance-difference' | 'day-balance-minus-equity' |
    'date-balance-minus-equity' | 'week-balance-minus-equity' | 'week-to-date-balance-minus-equity' |
    'month-balance-minus-equity' | 'month-to-date-balance-minus-equity' |
    'quarter-balance-minus-equity' | 'quarter-to-date-balance-minus-equity' | 'year-balance-minus-equity' |
    'year-to-date-balance-minus-equity' | 'lifetime-balance-minus-equity' |
    'day-equity-difference' | 'date-equity-difference' | 'week-equity-difference' |
    'week-to-date-equity-difference' | 'month-equity-difference' |
    'month-to-date-equity-difference' | 'quarter-equity-difference' | 'quarter-to-date-equity-difference' |
    'year-equity-difference' | 'year-to-date-equity-difference' | 'lifetime-equity-difference';

/**
 * CopyFactory external signal update payload
 */
export declare type CopyFactoryExternalSignalUpdate = {

  /**
   * trade symbol
   */
  symbol: string,

  /**
   * trade type (one of POSITION_TYPE_BUY, POSITION_TYPE_SELL, ORDER_TYPE_BUY_LIMIT, ORDER_TYPE_SELL_LIMIT, 
   * ORDER_TYPE_BUY_STOP, ORDER_TYPE_SELL_STOP)
   */
  type: string,

  /**
   * time the signal was emitted at
   */
  time: Date,

  /**
   * last time of the signal update
   */
  updateTime?: Date,

  /**
   * volume traded
   */
  volume: number,
  
  /**
   * expert advisor id
   */
  magic?: number,

  /**
   * stop loss price
   */
  stopLoss?: number,

  /**
   * take profit price
   */
  takeProfit?: number,

  /**
   * pending order open price
   */
  openPrice?: number
}

/**
 * CopyFactory external signal remove payload
 */
export declare type CopyFactoryExternalSignalRemove = {

  /**
   * the time signal was removed (closed) at
   */
  time: Date
}

/**
 * CopyFactory strategy stopout
 */
export declare type CopyFactoryStrategyStopout = {

  /**
   * Subscriber id
   */
  subscriberId: string,

  /**
   * strategy which was stopped out
   */
  strategy: CopyFactoryStrategyIdAndName,

  /**
   * flag indicating that stopout is partial
   */
  partial: boolean,

  /**
   * stopout reason
   */
  reason: CopyFactoryStrategyStopoutReason,

  /**
   * human-readable description of the stopout reason
   */
  reasonDescription: string,

  /**
   * flag indicating if positions should be closed
   */
  closePositions?: boolean,

  /**
   * time the strategy was stopped at
   */
  stoppedAt: Date,

  /**
   * time the strategy is stopped till
   */
  stoppedTill: Date,

  /**
   * Stopout event sequence number
   */
  sequenceNumber: number
}

/**
 * Trade copying user log record
 */
export declare type CopyFactoryUserLogMessage = {

  /**
   * log record time
   */
  time: Date,

  /**
   * symbol traded
   */
  symbol?: string,

  /**
   * id of the strategy event relates to
   */
  strategyId?: string,
  
  /**
   * name of the strategy event relates to
   */
  strategyName?: string,

  /**
   * position id event relates to
   */
  positionId?: string,

  /**
   * side of the trade event relates to. One of buy, sell, close
   */
  side?: string,

  /**
   * type of the trade event relates to. One of market, limit, stop
   */
  type?: string,

  /**
   * open price for limit and stop orders
   */
  openPrice?: number,

  /**
   * log level. One of INFO, WARN, ERROR
   */
  level: string,

  /**
   * log message
   */
  message: string
}