/**
 * Manages loggers of the entire sdk
 */
declare class LoggerManager {
    /**
     * Enables using Log4js logger with extended log levels for debugging instead of
     * console.* functions. Note that log4js configuration performed by the user.
     */
    static useLog4js(): void;
    /**
     * Creates a new logger for specified category
     * @param {String} category Logger category
     * @return {Logger} Created logger
     */
    static getLogger(category: any): NativeLogger;
}
/**
 * Native logger that uses console.* functions
 */
declare class NativeLogger {
    /**
     * Supposed to log messages of trace level
     * @param {String|Function} message Message or message generator to log
     * @param {*[]} args Additional args to message
     */
    trace(message: any, ...args: any[]): void;
    /**
     * Supposed to log messages of debug level
     * @param {String|Function} message Message or message generator to log
     * @param {*[]} args Additional args to message
     */
    debug(message: any, ...args: any[]): void;
    /**
     * Prints a message with console.log
     * @param {String|Function} message Message or message generator to log
     * @param {*[]} args Additional args to message
     */
    info(message: any, ...args: any[]): void;
    /**
     * Prints a message with console.warn
     * @param {String|Function} message Message or message generator to log
     * @param {*[]} args Additional args to message
     */
    warn(message: any, ...args: any[]): void;
    /**
     * Prints a message with console.error
     * @param {String|Function} message Message or message generator to log
     * @param {*[]} args Additional args to message
     */
    error(message: any, ...args: any[]): void;
    /**
     * Prints a message with console.error
     * @param {String|Function} message Message or message generator to log
     * @param {*[]} args Additional args to message
     */
    fatal(message: any, ...args: any[]): void;
    _log(level: any, message: any, args: any): void;
}
export default LoggerManager;
