"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, /**
 * metaapi.cloud MetaTrader API client
 */ "default", {
    enumerable: true,
    get: function() {
        return MetaApiClient;
    }
});
const _methodAccessError = /*#__PURE__*/ _interop_require_default(require("./methodAccessError"));
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
let MetaApiClient = class MetaApiClient {
    _domainClient;
    _token;
    /**
   * Constructs MetaTrader API client instance
   * @param {DomainClient} domainClient domain client
   */ constructor(domainClient){
        this._domainClient = domainClient;
        this._token = domainClient.token;
    }
    /**
   * Returns type of current token
   * @returns {string} Type of current token
   * @protected
   */ get _tokenType() {
        if (typeof this._token === "string" && this._token.split(".").length === 3) {
            return "api";
        }
        if (typeof this._token === "string" && this._token.split(".").length === 1) {
            return "account";
        }
        return "";
    }
    /**
   * Checks that current token is not api token
   * @returns {boolean} Indicator of absence api token
   * @protected
   */ _isNotJwtToken() {
        return typeof this._token !== "string" || this._token.split(".").length !== 3;
    }
    /**
   * Checks that current token is not account token
   * @returns {boolean} Indicator of absence account token
   * @protected
   */ _isNotAccountToken() {
        return typeof this._token !== "string" || this._token.split(".").length !== 1;
    }
    /**
   * Handles no accessing to the method
   * @param {string} methodName Name of method
   * @protected
   * @throws
   */ _handleNoAccessError(methodName) {
        return Promise.reject(new _methodAccessError.default(methodName, this._tokenType));
    }
};

//# sourceMappingURL=data:application/json;base64,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