'use strict';
function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) {
    try {
        var info = gen[key](arg);
        var value = info.value;
    } catch (error) {
        reject(error);
        return;
    }
    if (info.done) {
        resolve(value);
    } else {
        Promise.resolve(value).then(_next, _throw);
    }
}
function _async_to_generator(fn) {
    return function() {
        var self = this, args = arguments;
        return new Promise(function(resolve, reject) {
            var gen = fn.apply(self, args);
            function _next(value) {
                asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value);
            }
            function _throw(err) {
                asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err);
            }
            _next(undefined);
        });
    };
}
let TransactionListener = class TransactionListener {
    /**
   * Calls a predefined function with the packets data
   * @param {CopyFactoryTransaction[]} transactionEvent transaction event with an array of packets
   */ onTransaction(transactionEvent) {
        return _async_to_generator(function*() {
            throw Error('Abstract method onTransaction has no implementation');
        })();
    }
    /**
   * Calls a predefined function with the received error
   * @param {Error} error error received during retrieve attempt
   */ onError(error) {
        return _async_to_generator(function*() {})();
    }
};
/**
 * Transaction listener for handling a stream of transaction events
 */ export { TransactionListener as default };

//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIjxhbm9uPiJdLCJzb3VyY2VzQ29udGVudCI6WyIndXNlIHN0cmljdCc7XG5cbi8qKlxuICogVHJhbnNhY3Rpb24gbGlzdGVuZXIgZm9yIGhhbmRsaW5nIGEgc3RyZWFtIG9mIHRyYW5zYWN0aW9uIGV2ZW50c1xuICovXG5leHBvcnQgZGVmYXVsdCBjbGFzcyBUcmFuc2FjdGlvbkxpc3RlbmVyIHtcblxuICAvKipcbiAgICogQ2FsbHMgYSBwcmVkZWZpbmVkIGZ1bmN0aW9uIHdpdGggdGhlIHBhY2tldHMgZGF0YVxuICAgKiBAcGFyYW0ge0NvcHlGYWN0b3J5VHJhbnNhY3Rpb25bXX0gdHJhbnNhY3Rpb25FdmVudCB0cmFuc2FjdGlvbiBldmVudCB3aXRoIGFuIGFycmF5IG9mIHBhY2tldHNcbiAgICovXG4gIGFzeW5jIG9uVHJhbnNhY3Rpb24odHJhbnNhY3Rpb25FdmVudCkge1xuICAgIHRocm93IEVycm9yKCdBYnN0cmFjdCBtZXRob2Qgb25UcmFuc2FjdGlvbiBoYXMgbm8gaW1wbGVtZW50YXRpb24nKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBDYWxscyBhIHByZWRlZmluZWQgZnVuY3Rpb24gd2l0aCB0aGUgcmVjZWl2ZWQgZXJyb3JcbiAgICogQHBhcmFtIHtFcnJvcn0gZXJyb3IgZXJyb3IgcmVjZWl2ZWQgZHVyaW5nIHJldHJpZXZlIGF0dGVtcHRcbiAgICovXG4gIGFzeW5jIG9uRXJyb3IoZXJyb3IpIHt9XG5cbn0iXSwibmFtZXMiOlsiVHJhbnNhY3Rpb25MaXN0ZW5lciIsIm9uVHJhbnNhY3Rpb24iLCJ0cmFuc2FjdGlvbkV2ZW50IiwiRXJyb3IiLCJvbkVycm9yIiwiZXJyb3IiXSwibWFwcGluZ3MiOiJBQUFBOzs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7QUFLZSxJQUFBLEFBQU1BLHNCQUFOLE1BQU1BO0lBRW5COzs7R0FHQyxHQUNELEFBQU1DLGNBQWNDLGdCQUFnQjtlQUFwQyxvQkFBQSxZQUFzQztZQUNwQyxNQUFNQyxNQUFNLHVEQUF1RDtRQUNyRTs7SUFFQTs7O0dBR0MsR0FDRCxBQUFNQyxRQUFRQyxLQUFLO2VBQW5CLG9CQUFBLFlBQXFCLENBQUM7O0FBRXhCO0FBbkJBOztDQUVDLEdBQ0QsU0FBcUJMLGlDQWdCcEIifQ==