'use strict';
function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) {
    try {
        var info = gen[key](arg);
        var value = info.value;
    } catch (error) {
        reject(error);
        return;
    }
    if (info.done) {
        resolve(value);
    } else {
        Promise.resolve(value).then(_next, _throw);
    }
}
function _async_to_generator(fn) {
    return function() {
        var self = this, args = arguments;
        return new Promise(function(resolve, reject) {
            var gen = fn.apply(self, args);
            function _next(value) {
                asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value);
            }
            function _throw(err) {
                asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err);
            }
            _next(undefined);
        });
    };
}
import MetaApiClient from '../../metaapi.client';
import randomstring from 'randomstring';
import LoggerManager from '../../../logger';
let StopoutListenerManager = class StopoutListenerManager extends MetaApiClient {
    /**
   * Returns the dictionary of stopout listeners
   * @returns {Object} dictionary of stopout listeners
   */ get stopoutListeners() {
        return this._stopoutListeners;
    }
    /**
   * Adds a stopout listener
   * @param {StopoutListener} listener 
   * @param {String} [accountId] account id
   * @param {String} [strategyId] strategy id
   * @param {Number} [sequenceNumber] event sequence number
   * @returns {String} stopout listener id
   */ addStopoutListener(listener, accountId, strategyId, sequenceNumber) {
        const listenerId = randomstring.generate(10);
        this._stopoutListeners[listenerId] = listener;
        this._startStopoutEventJob(listenerId, listener, accountId, strategyId, sequenceNumber);
        return listenerId;
    }
    /**
   * Removes stopout listener by id
   * @param {String} listenerId listener id 
   */ removeStopoutListener(listenerId) {
        delete this._stopoutListeners[listenerId];
    }
    _startStopoutEventJob(listenerId, listener, accountId, strategyId, sequenceNumber) {
        var _this = this;
        return _async_to_generator(function*() {
            let throttleTime = _this._errorThrottleTime;
            while(_this._stopoutListeners[listenerId]){
                const opts = {
                    url: '/users/current/stopouts/stream',
                    method: 'GET',
                    params: {
                        previousSequenceNumber: sequenceNumber,
                        subscriberId: accountId,
                        strategyId: strategyId,
                        limit: 1000
                    },
                    headers: {
                        'auth-token': _this._token
                    },
                    json: true
                };
                try {
                    const packets = yield _this._domainClient.requestCopyFactory(opts, true);
                    yield listener.onStopout(packets);
                    throttleTime = _this._errorThrottleTime;
                    if (_this._stopoutListeners[listenerId] && packets.length) {
                        sequenceNumber = packets.slice(-1)[0].sequenceNumber;
                    }
                } catch (err) {
                    yield listener.onError(err);
                    _this._logger.error(`Failed to retrieve stopouts stream for strategy ${strategyId}, ` + `listener ${listenerId}, retrying in ${Math.floor(throttleTime / 1000)} seconds`, err);
                    yield new Promise((res)=>setTimeout(res, throttleTime));
                    throttleTime = Math.min(throttleTime * 2, 30000);
                }
            }
        })();
    }
    /**
   * Constructs stopout listener manager instance
   * @param {DomainClient} domainClient domain client
   */ constructor(domainClient){
        super(domainClient);
        this._domainClient = domainClient;
        this._stopoutListeners = {};
        this._errorThrottleTime = 1000;
        this._logger = LoggerManager.getLogger('StopoutListenerManager');
    }
};
/**
 * Stopout event listener manager
 */ export { StopoutListenerManager as default };

//# sourceMappingURL=data:application/json;base64,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