'use strict';
function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) {
    try {
        var info = gen[key](arg);
        var value = info.value;
    } catch (error) {
        reject(error);
        return;
    }
    if (info.done) {
        resolve(value);
    } else {
        Promise.resolve(value).then(_next, _throw);
    }
}
function _async_to_generator(fn) {
    return function() {
        var self = this, args = arguments;
        return new Promise(function(resolve, reject) {
            var gen = fn.apply(self, args);
            function _next(value) {
                asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value);
            }
            function _throw(err) {
                asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err);
            }
            _next(undefined);
        });
    };
}
let StopoutListener = class StopoutListener {
    /**
   * Calls a predefined function with the packets data
   * @param {CopyFactoryStrategyStopout[]} strategyStopoutEvent strategy stopout event with an array of packets
   */ onStopout(strategyStopoutEvent) {
        return _async_to_generator(function*() {
            throw Error('Abstract method onStopout has no implementation');
        })();
    }
    /**
   * Calls a predefined function with the received error
   * @param {Error} error error received during retrieve attempt
   */ onError(error) {
        return _async_to_generator(function*() {})();
    }
};
/**
 * Stopout listener for handling a stream of stopout events
 */ export { StopoutListener as default };

//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIjxhbm9uPiJdLCJzb3VyY2VzQ29udGVudCI6WyIndXNlIHN0cmljdCc7XG5cbi8qKlxuICogU3RvcG91dCBsaXN0ZW5lciBmb3IgaGFuZGxpbmcgYSBzdHJlYW0gb2Ygc3RvcG91dCBldmVudHNcbiAqL1xuZXhwb3J0IGRlZmF1bHQgY2xhc3MgU3RvcG91dExpc3RlbmVyIHtcblxuICAvKipcbiAgICogQ2FsbHMgYSBwcmVkZWZpbmVkIGZ1bmN0aW9uIHdpdGggdGhlIHBhY2tldHMgZGF0YVxuICAgKiBAcGFyYW0ge0NvcHlGYWN0b3J5U3RyYXRlZ3lTdG9wb3V0W119IHN0cmF0ZWd5U3RvcG91dEV2ZW50IHN0cmF0ZWd5IHN0b3BvdXQgZXZlbnQgd2l0aCBhbiBhcnJheSBvZiBwYWNrZXRzXG4gICAqL1xuICBhc3luYyBvblN0b3BvdXQoc3RyYXRlZ3lTdG9wb3V0RXZlbnQpIHtcbiAgICB0aHJvdyBFcnJvcignQWJzdHJhY3QgbWV0aG9kIG9uU3RvcG91dCBoYXMgbm8gaW1wbGVtZW50YXRpb24nKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBDYWxscyBhIHByZWRlZmluZWQgZnVuY3Rpb24gd2l0aCB0aGUgcmVjZWl2ZWQgZXJyb3JcbiAgICogQHBhcmFtIHtFcnJvcn0gZXJyb3IgZXJyb3IgcmVjZWl2ZWQgZHVyaW5nIHJldHJpZXZlIGF0dGVtcHRcbiAgICovXG4gIGFzeW5jIG9uRXJyb3IoZXJyb3IpIHt9XG5cbn0iXSwibmFtZXMiOlsiU3RvcG91dExpc3RlbmVyIiwib25TdG9wb3V0Iiwic3RyYXRlZ3lTdG9wb3V0RXZlbnQiLCJFcnJvciIsIm9uRXJyb3IiLCJlcnJvciJdLCJtYXBwaW5ncyI6IkFBQUE7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7OztBQUtlLElBQUEsQUFBTUEsa0JBQU4sTUFBTUE7SUFFbkI7OztHQUdDLEdBQ0QsQUFBTUMsVUFBVUMsb0JBQW9CO2VBQXBDLG9CQUFBLFlBQXNDO1lBQ3BDLE1BQU1DLE1BQU0sbURBQW1EO1FBQ2pFOztJQUVBOzs7R0FHQyxHQUNELEFBQU1DLFFBQVFDLEtBQUs7ZUFBbkIsb0JBQUEsWUFBcUIsQ0FBQzs7QUFFeEI7QUFuQkE7O0NBRUMsR0FDRCxTQUFxQkwsNkJBZ0JwQiJ9